/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/

var STBGlobalGenericText = Object.create(STBModule.prototype);

STBGlobalGenericText.name = "GlobalGenericText";
STBGlobalGenericText.initPlugin = function () {

	var elements = $(".generic-text:not(.__done)");
	
	if (elements.length) {
		elements.each(function() {

			//update bgscheme on buttons and links
			var el		= $(this),
				css		= el.hasClass("ic") ? "ic" : "nc",
				items	= el.find(".btn:not(.ic,.nc),.link:not(.ic,.nc)"),
				pIcon	= el.find("p > .icon"),
				img		= el.find("img");


			if (items.length) {
				items.addClass(css);
			}

			//remove height from images and add the responsive
			if (img.length)	{
				img.removeAttr("height");
				img.addClass("img-responsve img-fluid");
			}

			//add with icon class to paragraphs with icon on the first position
			if (pIcon.length) {
				pIcon.each(function() {
					var parent = $(this).parent();
					
					if (parent.html().indexOf('<span class=\"icon') == 0) {
						parent.addClass("with-icon");
					}
				});
			}
			el.addClass("__done");
		});
	}
}

STBGlobalGenericText.runOnReady = function() {
	STBGlobalGenericText.initPlugin();
}

STBGlobalGenericText.runOnContentUpdate = function() {
	STBGlobalGenericText.initPlugin();
}

site.registerModule(STBGlobalGenericText);
